<?php

namespace App\Http\Controllers\SitePublic\Site;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicAdmissionType;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicFeeSubHead;
use App\Models\Academic\AcademicPeriodType;
use App\Models\Academic\AcademicSection;
use App\Models\Academic\AcademicSession;
use App\Models\Academic\AcademicSessionType;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicStudentCategory;
use App\Models\Academic\AcademicStudentType;
use App\Models\Academic\AcademicVersion;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Relation\Relation;
use App\Models\Site\Batch\GlobalBatchDetail;
use App\Models\Site\Employee\TeacherAssignToClassSection;
use App\Models\Site\GlobalSiteClassSessionSerialSetting;
use App\Models\Site\Fee\SiteStudentFeeSubHeadAllocation;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use App\Models\Site\SiteInfoSetting\GlobalSiteInfoSetting;
use App\Models\Site\GlobalSiteShiftClassGroupSectionSetting;
use App\Models\Academic\AcademicResultPrimaryType;

use App\Models\Student\StudentHistory;
use App\Models\Student\PublicStudentHistory;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\Site\Result\SiteIndividualCombineSubjectResultStore;
use App\Models\Site\Result\GlobalSiteResultSystemSetting;
use App\Models\Site\Result\SiteStudentPrimaryResultDetail;
use Exception;
use Illuminate\Support\Facades\Auth;
use App\Models\Site\Employee\Employee;

use Response;
use Session;
use Carbon\Carbon;
use Illuminate\Support\Facades\Log;
use App\Models\Academic\AcademicExamType;
use App\Models\Site\Result\GlobalSiteExamResultReportSetting;
use PDF;

class PublicResultController extends Controller
{
    private $siteShiftClassGroupSectionSetting;
    private $academicClassGroup;

    public function __construct(AcademicClassGroup $academicClassGroup, GlobalSiteShiftClassGroupSectionSetting $siteShiftClassGroupSectionSetting)
    {
      
        $this->siteShiftClassGroupSectionSetting = $siteShiftClassGroupSectionSetting;
        $this->academicClassGroup = $academicClassGroup;
    }

    private function getStudenthistoryIDs(Request $request, $site_id){
   $data = $request->all();
  

   $studentList = GlobalStudentHistory::select('id', 'user_id','student_roll_number')
       ->with(['student' => function ($q) {
           $q->with('latestPhoto');
           $q->select('id');
           $q->where('user_type', 'student');
       },
           'year', 'shift','department','stClass','classGroup','session','section'
       ])
       ->where('site_id', $site_id)
       ->where('academic_group_id', $request->academic_group_id)
       ->where('academic_version_id', $request->academic_version_id)
       ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
           return $query->where('academic_year_id', $data['academic_year_id']);
       })
       ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
           return $query->where('academic_shift_id', $data['academic_shift_id']);
       })
       ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
           return $query->where('academic_department_id', $data['academic_department_id']);
       })
       ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
           return $query->where('academic_class_id', $data['academic_class_id']);
       })
       ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
           return $query->where('academic_class_group_id', $data['academic_class_group_id']);
       })
       ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
           return $query->where('academic_section_id', $data['academic_section_id']);
       })
       ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
           return $query->where('academic_session_id', $data['academic_session_id']);
       })
       ->orderBy('student_roll_number')
       ->orderBy('academic_department_id')
       ->orderBy('academic_class_id')
       ->orderBy('academic_class_group_id')
       ->orderBy('academic_section_id')
       ->get();

   return $studentList;
}

   private function getResultListForPublic($request){

    $site_list = $this->getSiteId();
    $site_id = $site_list->id;

      $studentList=$this->getStudenthistoryIDs($request, $site_id);
      $student_ids=$studentList->pluck('id');
     

      $primary_exam_type_ids=SiteStudentPrimaryResultDetail::whereIn('student_history_id', $student_ids)
          ->where('result_public_publish_status', true)
          ->pluck('academic_result_primary_type_id')
          ->unique()
          ->filter();

          $result_primary_type_list=AcademicResultPrimaryType::whereIn('id', $primary_exam_type_ids)->get(['id', 'name']);

          ///================
        //   $site_list = $this->getSiteId();
        //   $site_id = $site_list->id;
        //   $siteSettings=SiteInfoSetting::where('site_id', $site_id)->first();
        //   $sectionIdArray=explode(',',$siteSettings->academic_section_ids);
        //   //academic_section_ids
        //   $section=AcademicSection::whereIn('id',$sectionIdArray)->get();

          

          ///============
       /// dd($section);
      return $result_primary_type_list;

   }

  


   public function versionYearShiftBasedSectionsOrClassGroupsAndSessionByClassForPublic(Request $requests)
   {
    //this function returns class groups by version,year, and shift if groups not present then sections
  
        $site_list = $this->getSiteId();
        $site_id = $site_list->id;

        $data = $requests->all();
        $group_id  =   $data['academic_group_id'];
        $version_id  =   $data['academic_version_id'];
        $year_id     =   $data['academic_year_id'];
        $shift_id    =   $data['academic_shift_id'];
        $class_id    =   $data['academic_class_id'];
     
  //  dd($data);

       if (!$data['academic_version_id'] || !$data['academic_year_id'] || !$data['academic_shift_id'] || !$data['academic_class_id']) {
           return Response::json(['message' => 'Select * Marked Field!'], 411);
       }


       $SiteInfoTableData = GlobalSiteInfoSetting::where('site_id', $site_id)->where('academic_group_id',$group_id)->select('id', 'batch_present_status')
           ->first();


       if ($SiteInfoTableData->batch_present_status) {
           $batch_list = GlobalBatchDetail::where('academic_class_id', $class_id)
               ->where('academic_group_id', $group_id)
               ->where('site_id', $site_id)
               ->where('academic_version_id', $version_id)
               ->where('academic_shift_id', $shift_id)
               ->where('academic_year_id', $year_id)
               ->select('id', 'batch_name', 'batch_code')
               ->get();

           //   dd($class_id,$version_id,$shift_id,$year_id);


       } else {
           $batch_list = [];
       }


       $group_list = [];
       $section_list = [];

       $group_present = $this->siteShiftClassGroupSectionSetting
           ->where('site_id', $site_id)
           ->where('academic_group_id', $group_id)
           ->where('academic_version_id', $version_id)
           ->where('academic_year_id', $year_id)
           ->where('academic_shift_id', $shift_id)
           ->where('academic_class_id', $class_id)
           ->whereNotNull('academic_class_group_id')
           ->get();
//        return $group_present;


       if (count($group_present) > 0) {
           $group_ids = $group_present->pluck('academic_class_group_id')->toArray();
           $group_list = $this->academicClassGroup
               ->whereIn('id', $group_ids)
               ->get();


       } else {

           $section_present = $this->siteShiftClassGroupSectionSetting
                ->where('site_id', $site_id)
                ->where('academic_group_id', $group_id)
               ->where('academic_version_id', $version_id)
               ->where('academic_year_id', $year_id)
               ->where('academic_shift_id', $shift_id)
               ->where('academic_class_id', $class_id)
               ->first();

           $exploded_section_ids = explode(',', $section_present->academic_section_ids ?? null);

           $section_list = AcademicSection::select('id', 'section_name')
               ->whereIn('id', $exploded_section_ids)
               ->get();
            }

       $session_exist = GlobalSiteClassSessionSerialSetting::where('academic_class_id', $data['academic_class_id'])
            ->where('site_id', $site_id)
           ->where('academic_group_id', $group_id)
           ->where('academic_version_id', $data['academic_version_id'])
           ->where('academic_year_id', $data['academic_year_id'])
           ->where('academic_shift_id', $data['academic_shift_id'])
           ->when($data['academic_department_id'],function($q) use ($data){
                $q->where('academic_department_id', $data['academic_department_id']);
           })
           ->first();

       if ($session_exist && $session_exist->session_present) {
           $exploded_session_list = explode(',', $session_exist->session_ids);
           $session_list = AcademicSession::whereIn('id', $exploded_session_list)->get();
       } else {
           $session_list = [];
       }
       $resultList=$this->getResultListForPublic($requests);

       return [$group_list, $section_list, $session_list, $batch_list, $resultList];
   }


   public function getSiteClassGroupBaseSectionSessionList(Request $requests)
   {//this function returns class groups by version,year, and shift if groups not present then sections

       $data = $requests->all();
       $group_id  =   $data['academic_group_id'];
       $version_id  =   $data['academic_version_id'];
       $year_id     =   $data['academic_year_id'];
       $shift_id    =   $data['academic_shift_id'];
       $class_id    =   $data['academic_class_id'];
       $class_group_id  =   $data['academic_class_group_id'];
    // dd($year_id);
       $site_list = $this->getSiteId();
        $site_id = $site_list->id;

        $groupPresentCount = GlobalSiteShiftClassGroupSectionSetting::select('academic_class_group_id')
        ->where('academic_version_id', $version_id)
        ->where('academic_year_id', $year_id)
        ->where('academic_class_id', $class_id)
        ->whereNotNull('academic_class_group_id')
        ->count();

        $sessionPresentCheck = GlobalSiteClassSessionSerialSetting::where('site_id', $site_id)
        ->where('academic_group_id', $group_id)->where('academic_class_id', $class_id)->first();

        if ($sessionPresentCheck) {
        if ($sessionPresentCheck->session_present) {
            $SiteInfoTableData = GlobalSiteInfoSetting::where('site_id', $site_id)->where('academic_group_id',$group_id)->first();
            $Sessionlistsplite = explode(',', $SiteInfoTableData->academic_session_ids);
            $Sessionlist = AcademicSession::whereIn('id', $Sessionlistsplite)->get();
        } else {
            $Sessionlist = [];
        }
        } else {
        $Sessionlist = [];
        }


        if (!$groupPresentCount) {

        $SiteClassBaseSectionCount = GlobalSiteShiftClassGroupSectionSetting::select('academic_shift_id')
            ->where('site_id', $site_id)
            ->where('academic_group_id', $group_id)
            ->where('academic_version_id', $version_id)
            ->where('academic_year_id', $year_id)
            ->where('academic_class_id', $class_id)
            ->count();


        if (!$shift_id && $SiteClassBaseSectionCount > 1) {
            return 4001;
        } else if (!$shift_id && $SiteClassBaseSectionCount == 1) {
            $SiteClassBaseSection = GlobalSiteShiftClassGroupSectionSetting::select('academic_section_ids')
                ->where('site_id', $site_id)
                ->where('academic_group_id', $group_id)
                ->where('academic_version_id', $version_id)
                ->where('academic_year_id', $year_id)
                ->where('academic_class_id', $class_id)
                ->first();

        } else if ($shift_id && $class_id) {
            $SiteClassBaseSection = GlobalSiteShiftClassGroupSectionSetting::select('academic_section_ids')
                ->where('site_id', $site_id)
                ->where('academic_group_id', $group_id)
                ->where('academic_version_id', $version_id)
                ->where('academic_year_id', $year_id)
                ->where('academic_class_id', $class_id)
                ->where('academic_shift_id', $shift_id)
                ->first();

            }
        } else {
        if (!$shift_id && !$class_group_id) {
            return 4001;
        } else if ($shift_id && !$class_group_id) {
            $SiteGroup = GlobalSiteShiftClassGroupSectionSetting::select('academic_class_group_id')
                ->where('site_id', $site_id)
                ->where('academic_group_id', $group_id)
                ->where('academic_version_id', $version_id)
                ->where('academic_year_id', $year_id)
                ->where('academic_class_id', $class_id)
                ->where('academic_shift_id', $shift_id)
                ->get();

            $sectionDataList = AcademicClassGroup::select('id', 'group_name')
                ->whereIn('id', $SiteGroup)
                ->get();


            return [2001, $sectionDataList, $Sessionlist];
        } else {
            $SiteClassBaseSectionCount = GlobalSiteShiftClassGroupSectionSetting::select('academic_shift_id')
                ->where('site_id', $site_id)
                ->where('academic_group_id', $group_id)
                ->where('academic_version_id', $version_id)
                ->where('academic_year_id', $year_id)
                ->where('academic_class_id', $class_id)
                ->where('academic_class_group_id', $class_group_id)
                ->get()
                ->count();


            if (!$shift_id && $SiteClassBaseSectionCount > 1) {
                return 4001;
            } else if (!$shift_id && $SiteClassBaseSectionCount == 1) {
                $SiteClassBaseSection = GlobalSiteShiftClassGroupSectionSetting::select('academic_section_ids')
                    ->where('site_id', $site_id)
                    ->where('academic_group_id', $group_id)
                    ->where('academic_version_id', $version_id)
                    ->where('academic_year_id', $year_id)
                    ->where('academic_class_id', $class_id)
                    ->where('academic_class_group_id', $class_group_id)
                    ->first();
            } else if ($shift_id && $class_id) {
                $SiteClassBaseSection = GlobalSiteShiftClassGroupSectionSetting::select('academic_section_ids')
                    ->where('site_id', $site_id)
                    ->where('academic_group_id', $group_id)
                    ->where('academic_version_id', $version_id)
                    ->where('academic_year_id', $year_id)
                    ->where('academic_class_id', $class_id)
                    ->where('academic_shift_id', $shift_id)
                    ->where('academic_class_group_id', $class_group_id)
                //    ->where('site_id',$site_id)
                    ->first();
                  //  dd($SiteClassBaseSection);
            }
        }
        }

        $SectionData = explode(',', $SiteClassBaseSection->academic_section_ids ?? null);

        $SectionDataList = AcademicSection::select('id', 'section_name')
        ->whereIn('id', $SectionData)
        ->get();

        return [$SectionDataList, $Sessionlist];
   }

   private function getSiteId()
   {
       $domain = "";
       if (isset($_SERVER['HTTP_HOST']) && !empty($_SERVER['HTTP_HOST'])) {
           $getHost = explode(".", $_SERVER['HTTP_HOST']);
           $domain = array_shift($getHost);
       }

       $get_site_id = SiteInfo::select('id', 'site_logo', 'site_alias')->where('site_alias', $domain)->first();

       return $get_site_id;
   }

   public function getStudentResulForPublic(Request $request){

    $this->validate($request, [
        "academic_group_id" => "required",
        "academic_version_id" => "required",
        "academic_year_id" => "required",
        "academic_shift_id" => "required",
        "academic_class_id" => "required",
        "academic_result_primary_type_id" => "required",
        "student_roll_number" => "required",
    ]);
      $data = $request->all();
      //dd($data);

      $site_list = $this->getSiteId();
      $site_id = $site_list->id;

 //     $student_ids=[$request->student_history_id];
      $studentHistory=GlobalStudentHistory::with('site')
         ->where('site_id', $site_id)
         ->where('academic_group_id', $request->academic_group_id)
         ->where('academic_year_id', $request->academic_year_id)
         ->where('academic_shift_id', $request->academic_shift_id)
         ->where('academic_class_id', $request->academic_class_id)
         ->where('student_roll_number', $request->student_roll_number)
         ->when($data['academic_class_group_id'], function($q) use ($request){
            $q->where('academic_class_group_id', $request->academic_class_group_id);
         })
         ->when($data['academic_section_id'], function($q) use ($request){
            $q->where('academic_section_id', $request->academic_section_id);
         })
         ->when($data['site_batch_detail_id'], function($q) use ($request){
            $q->where('site_batch_detail_id', $request->site_batch_detail_id);
         })
         ->select('id','site_id',)
         ->orderBy('id','DESC')
         ->first();
       
       if($studentHistory){
            $dataaa=SiteStudentPrimaryResultDetail::with(['studentHistory'=>function ($query) {
                $query->select('id', 'user_id', 'academic_shift_id', 'academic_class_id', 'academic_department_id',
                    'academic_session_id', 'academic_student_category_id', 'board_registration_number',
                    'academic_class_group_id', 'academic_section_id', 'academic_year_id', 'student_roll_number',
                    'registration_no');
                $query->with(['student' => function ($q) {
                    $q->with('latestPhoto');
                    $q->select('id','date_of_birth');
                    $q->where('user_type', 'student');
                },
                'site','year', 'shift','department','stClass','classGroup','session','section'
                ]);
            }, 'academicResultPrimaryType'])
            ->where('student_history_id', $studentHistory->id)
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->where('result_public_publish_status', true)
            ->where('status', true)
            ->get();

          //  dd($dataaa);
          
            
                if(count($dataaa)<=0){
                    return response()->json(['message'=>'Result Not Found','status'=>false],422);
                }
  
       }else{
        return response()->json(['message'=>'Student Not Found','status'=>false],422);
       }

    //   $hight_marks_ids=SiteIndividualCombineSubjectResultStore::
    //      where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
    //      // ->whereIn('student_history_id',$student_ids)
    //       ->where('status', true)
    //       ->pluck('exam_dependent_academic_subject_id')->unique()->filter();

         

    //   $hight_marks_list=[];
    //   foreach ($hight_marks_ids as $key => $value){
    //       $hight_marks_subject=SiteIndividualCombineSubjectResultStore::
    //       where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
    //           //->whereIn('student_history_id', $student_ids)
    //           ->where('exam_dependent_academic_subject_id', $value)
    //           ->where('status', true)
    //           ->orderBy('obtain_raw_total_marks', 'desc')
    //           ->select('exam_dependent_academic_subject_id', 'obtain_raw_total_marks')
    //           ->first();

    //       if($hight_marks_subject){
    //           $hight_marks_list[]=$hight_marks_subject;
    //       }

    //   }
 
      $a_arr=Array();
      $a_array=[];

      foreach ($dataaa as $key => $value){
       
          $b_array=[];
          foreach ($value->site_individual_combine_subject_result_store_ids as $keyt => $valuet){
              $b_array[]=$valuet->subject_detail;
          }

          //$subject_ids=collect($b_array)->pluck('exam_dependent_academic_subject_id')->unique();
        //  $result_show_in_table_bellow_status_present=collect($b_array)->pluck('result_show_in_table_bellow_status')->unique()->filter();
         
        //  $highest_marks_list=collect($hight_marks_list)->whereIn('exam_dependent_academic_subject_id', $subject_ids);

          $a_arr['academic_result_primary_type_id']=$value->academic_result_primary_type_id;
          $a_arr['result_type_name']=$value->academicResultPrimaryType->name;
         // $a_arr['student_history_id']=$value->student_history_id;
          $a_arr['fail_subject_count']=$value->fail_subject_count;
          $a_arr['gpa']=$value->gpa;
          $a_arr['grade']=$value->grade;
        //  $a_arr['student_rank']=$value->student_rank;
        //  $a_arr['site_result_primary_setting_id']=$value->site_result_primary_setting_id;
        //  $a_arr['academic_result_primary_type_id']=$value->academic_result_primary_type_id;
          $a_arr['subject_list']=$b_array;
        //  $a_arr['table_header']=$value->table_header;
         // $a_arr['highest_marks']=$highest_marks_list;
          $a_arr['student_history']=$value->studentHistory;
          $a_arr['site_name']=$studentHistory->site->site_name;

        //   $a_arr['student_photo']=$value->studentHistory->student->latestPhoto?
        //       $value->studentHistory->student->latestPhoto->name:'image-not.png';

        //  $a_arr['result_show_in_table_bellow_status_present']=count($result_show_in_table_bellow_status_present)>0?1:0;

         // $a_arr['classtest_is_present']=$value->classtest_is_present;
        //  $a_arr['combine_subject_present']=$value->combine_subject_present;
        //  $a_arr['final_grade_without_optional']=$value->final_grade_without_optional;
        //  $a_arr['final_point_without_optional']=$value->final_point_without_optional;
        //  $a_arr['id']=$value->id;
        //  $a_arr['raw_obtain_marks_percentage']=number_format((float)$value->raw_obtain_marks_percentage, 2, '.', '');
          $a_arr['sum_of_obtain_percent_total_marks']=$value->sum_of_obtain_percent_total_marks;
          $a_arr['sum_of_obtain_raw_total_marks']=$value->sum_of_obtain_raw_total_marks;
          $a_arr['sum_of_raw_total_marks']=$value->sum_of_raw_total_marks;
          $a_arr['result_public_full_publish_status']=$value->result_public_full_publish_status;
          $a_arr['status']=true;

         
          $a_array[$key]=array_merge($a_arr);

      }
      return $a_array;
   }

   
   public function getSiteStudentAndPrimaryResultTypeBaseResultDetail($request){

    $this->validate($request, [
        "academic_group_id" => "required",
        "academic_version_id" => "required",
        "academic_year_id" => "required",
        "academic_shift_id" => "required",
        "academic_class_id" => "required",
        "academic_result_primary_type_id" => "required",
        "student_roll_number" => "required",
    ]);
      $data = $request->all();
      //dd($data);

      $site_list = $this->getSiteId();
      $site_id = $site_list->id;

    
      $studentHistory=GlobalStudentHistory::with('site')
            ->where('site_id', $site_id)
            ->where('academic_group_id', $request->academic_group_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('student_roll_number', $request->student_roll_number)
            ->when($data['academic_class_group_id'], function($q) use ($request){
                $q->where('academic_class_group_id', $request->academic_class_group_id);
            })
            ->when($data['academic_section_id'], function($q) use ($request){
                $q->where('academic_section_id', $request->academic_section_id);
            })
            ->when($data['site_batch_detail_id'], function($q) use ($request){
                $q->where('site_batch_detail_id', $request->site_batch_detail_id);
            })
            ->select('id','site_id','student_roll_number')
            ->orderBy('id','DESC')
            ->first();
     
       if($studentHistory){
            $dataaa=SiteStudentPrimaryResultDetail::with(['studentHistory'=>function ($query) {
                $query->select('id', 'user_id', 'academic_shift_id', 'academic_class_id', 'academic_department_id',
                    'academic_session_id', 'academic_student_category_id', 'board_registration_number',
                    'academic_class_group_id', 'academic_section_id', 'academic_year_id', 'student_roll_number',
                    'registration_no');
                $query->with(['student' => function ($q) {
                    $q->with('latestPhoto');
                    $q->select('id','date_of_birth');
                    $q->where('user_type', 'student');
                },
                'site','year', 'shift','department','stClass','classGroup','session','section'
                ]);
            }, 'academicResultPrimaryType'])
            ->where('student_history_id', $studentHistory->id)
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->where('result_public_publish_status', true)
            ->where('result_public_full_publish_status', true)
            ->where('status', true)
            ->get();

         //   dd(count($dataaa));
          
            
        if(count($dataaa)<=0){
            return response()->json(['message'=>'Result Not Found','status'=>false],422);
        }
  
       }else{
        return response()->json(['message'=>'Student Not Found','status'=>false],422);
       }

          // Employee
          $institute_head = Employee::where('institute_head', 1)->first();
          $site_info =  SiteInfo::find(Session::get('SITE_ID'));
   
          $get_signature = $institute_head->signature ?? '/img/signature/signature.png';
          $get_designation = $institute_head->designation->name ?? 'Institution Head';


    
      $a_arr=Array();
      $a_array=[];

      foreach ($dataaa as $key => $value){
       
          $b_array=[];
          foreach ($value->site_individual_combine_subject_result_store_ids as $keyt => $valuet){
              $b_array[]=$valuet->subject_detail;
          }

          $result_show_in_table_bellow_status_present=collect($b_array)->pluck('result_show_in_table_bellow_status')->unique()->filter();

        $a_arr['academic_result_primary_type_id']=$value->academic_result_primary_type_id;
            $a_arr['result_type_name']=$value->academicResultPrimaryType->name;
            $a_arr['student_history_id']=$value->student_history_id;
            $a_arr['fail_subject_count']=$value->fail_subject_count;
            $a_arr['gpa']=$value->gpa;
            $a_arr['grade']=$value->grade;
            $a_arr['student_rank']=$value->student_rank;
            $a_arr['site_result_primary_setting_id']=$value->site_result_primary_setting_id;
            $a_arr['academic_result_primary_type_id']=$value->academic_result_primary_type_id;
            $a_arr['subject_list']=$b_array;
            $a_arr['table_header']=$value->table_header;
            $a_arr['highest_marks']=json_decode($value->highest_marks_list);
            $a_arr['student_history']=$value->studentHistory;
            
            $a_arr['total_student']=$value->total_student;

            $a_arr['student_photo']=$value->studentHistory->student->latestPhoto?
                $value->studentHistory->student->latestPhoto->name:'image-not.png';

            $a_arr['result_show_in_table_bellow_status_present']=count($result_show_in_table_bellow_status_present)>0?1:0;
    
            $a_arr['result_type_name']=$value->academicResultPrimaryType->name;
            $a_arr['result_type_id']=$value->academicResultPrimaryType->id;

            $a_arr['classtest_is_present']=$value->classtest_is_present;
            $a_arr['combine_subject_present']=$value->combine_subject_present;
            $a_arr['final_grade_without_optional']=$value->final_grade_without_optional;
            $a_arr['final_point_without_optional']=$value->final_point_without_optional;
            $a_arr['id']=$value->id;
            $a_arr['raw_obtain_marks_percentage']=number_format((float)$value->raw_obtain_marks_percentage, 2, '.', '');
            $a_arr['sum_of_obtain_percent_total_marks']=$value->sum_of_obtain_percent_total_marks;
            $a_arr['sum_of_obtain_raw_total_marks']=$value->sum_of_obtain_raw_total_marks;
            $a_arr['sum_of_raw_total_marks']=$value->sum_of_raw_total_marks;
            $a_arr['sum_of_obtain_total_marks_for_show']=$value->sum_of_obtain_total_marks_for_show;
          //  $a_arr['sum_of_obtain_raw_total_marks']=$value->sum_of_obtain_raw_total_marks;
          $a_arr['sum_of_obtain_total_percent_for_show']=$value->sum_of_obtain_total_percent_for_show;
          //$a_arr['obtain_total_marks_for_show']=$value->obtain_total_marks_for_show;

          $a_arr['institute_head_teacher_signature']=$get_signature;
          $a_arr['institute_head_teacher_designation']=$get_designation;
          $a_arr['address']=$site_info->site_name;
          $a_arr['comment']=$site_info->comment;

          $a_arr['academic_days']=$value->academic_days;
          $a_arr['present_days']=$value->present_days;
          $a_arr['absent_days']=$value->absent_days;
          $a_arr['behaviour']=$value->behaviour;
          $a_arr['cultural_activities']=$value->cultural_activities;
          $a_arr['bncc']=$value->bncc;
          $a_arr['debate']=$value->bncc;
          $a_arr['scout']=$value->scout;
          $a_arr['sports']=$value->sports;
          $a_arr['others']=$value->others;

          $a_array[$key]=array_merge($a_arr);
       //   $final_array[$key]=array_merge($a_arr);
      }

    
    $data = $request->all();
    $siteResultSystemSettingPresent=GlobalSiteResultSystemSetting::with(['academicResultSystem'])
        ->where('site_id', $site_id)
        ->where('academic_group_id', $request->academic_group_id)
        ->where('academic_year_id', $request->academic_year_id)
        ->where('academic_version_id', $request->academic_version_id)
        ->where('academic_class_id', $request->academic_class_id)
        ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
            return $query->where('academic_department_id', $data['academic_department_id']);
        })
        ->where('status',true)
        ->get()
        ->sortBy(function ($item) {
            return $item->academicResultSystem->serial ?? 0;
        });

    return [$a_array, $siteResultSystemSettingPresent];

}

   public function getStudentResulDetailsPdfForPublic(Request $request){
      //  dd($request->all());
        ini_set('memory_limit', '-1');
        $data = $request->all();

        $is_qrcode = true;
        $is_stdImage = true;
        $is_academic_perform = true;
        $head_signature_status =false;
        $report_tittle='';
        $report_tittle2='';

        $primaryResultList =  $this->getSiteStudentAndPrimaryResultTypeBaseResultDetail($request);
        $result_list_array=$primaryResultList[0];
        $result_system_list=$primaryResultList[1];

    // dd($result_list_array);
        //============ domain name =============
        $site_info =  SiteInfo::find(Session::get('SITE_ID'));
        if($site_info->domain_name==null){
             $alias = $site_info->site_alias;
            $url = config('app.url');
            $parsedUrl = parse_url($url);
            $host = $parsedUrl['host'];
            $host_names = explode(".", $host);
            $bottom_host_name = $host_names[count($host_names) - 2] . "." . $host_names[count($host_names) - 1];

            if ($host_names[count($host_names) - 1] == 'bd') {
                $bottom_host_name = $host_names[count($host_names) - 2] . "." . $host_names[count($host_names) - 1];
            }
            if (count($host_names) == 2) {
                $bottom_host_name = $host_names[count($host_names) - 1];
            }
            $domain = $parsedUrl['scheme'] . '://' . $alias . '.' . $bottom_host_name;
      
        }else{
            $domain = $site_info->domain_name;
        }

        // result settings 
        $site = $this->getSiteId($request);

        $resultSetting=GlobalSiteExamResultReportSetting::where('site_id', $site->id)->first();
       // dd($site->id);
        if(!$resultSetting){
            $resultSetting=[
                'sheet_no'=>'one',
                'site_address_show_status'=>true,
                'exam_type_show_status'=>true,
                'std_image_show_status'=>true,
                'qrcode_show_status'=>true,
                'countable_mark_show_status'=>false,
                'row_mark_show_status'=>false,
                'mark_percentage_show_status'=>true,
                'academic_perform_show_status'=>true,
                'behaviour_show_status'=>true,
                'curriculam_activities_show_status'=>true,
                'merit_list_show_status'=>true,
                'head_signature_show_status'=>'',
                'left_designation'=>null,
                'center_designation'=>null,
                'right_designation'=>'Institute Head',
             ];
       }
 
   

    //    if($resultSetting['sheet_no']=='two'){

    //     if($request->page_orientaion=='portrate'){
    //         $pdf = PDF::loadView('default.admin.site.result.result_report.site-base-multiple-student-result-detail-report-two',
    //             compact('result_list_array', 'report_tittle', 'report_tittle2', 'result_system_list', 'domain', 'resultSetting','site_info'))
    //             ->setWarnings(false);
    //     }
    //     else if($request->page_orientaion=='landscape'){
    //         $pdf = PDF::loadView('default.admin.site.result.result_report.site-base-landscape-multiple-student-result-detail-report-two',
    //             compact('result_list_array', 'report_tittle', 'report_tittle2', 'result_system_list', 'domain',
    //              'resultSetting','site_info'))
    //             ->setPaper('a4', 'landscape')->setWarnings(false);
    //     }

       
    // }elseif($resultSetting['sheet_no']=='three'){
    //    // if($request->page_orientaion=='portrate'){
    //         $pdf = PDF::loadView('default.admin.site.result.result_report.site-base-multiple-student-result-detail-report-three',
    //             compact('result_list_array', 'report_tittle', 'report_tittle2', 'result_system_list', 'domain', 'resultSetting','site_info'))
    //             ->setWarnings(false);
    //     // }
    //     // else if($request->page_orientaion=='landscape'){
    //     //     $pdf = PDF::loadView('default.admin.site.result.result_report.site-base-landscape-multiple-student-result-detail-report-two',
    //     //         compact('result_list_array', 'report_tittle', 'report_tittle2', 'result_system_list', 'domain',
    //     //          'resultSetting','site_info'))
    //     //         ->setPaper('a4', 'landscape')->setWarnings(false);
    //     // }

    // }else{

    //   //  if($request->page_orientaion=='portrate'){
    //         $pdf = PDF::loadView('default.admin.site.result.result_report.site-base-multiple-student-result-detail-report',
    //             compact('result_list_array', 'report_tittle', 'report_tittle2', 'result_system_list', 'domain', 'resultSetting','site_info'))
    //             ->setWarnings(false);
    //    // }
    // //   //  else if($request->page_orientaion=='landscape'){
    // //         $pdf = PDF::loadView('default.admin.site.result.result_report.site-base-landscape-multiple-student-result-detail-report',
    // //             compact('result_list_array', 'report_tittle', 'report_tittle2', 'result_system_list', 'domain',
    // //              'resultSetting','site_info'))
    // //             ->setPaper('a4', 'landscape')->setWarnings(false);
    // //    // }
    // }

    if ($resultSetting['sheet_no'] == 'two') {

        if ($request->page_orientaion == 'portrate') {
            $pdf = PDF::loadView(
                'default.admin.site.result.result_report.site-base-multiple-student-result-detail-report-two',
                compact('result_list_array', 'report_tittle', 'report_tittle2', 'result_system_list', 'domain', 'resultSetting', 'site_info')
            )
                ->setWarnings(false);
        } else if ($request->page_orientaion == 'landscape') {
            $pdf = PDF::loadView(
                'default.admin.site.result.result_report.site-base-landscape-multiple-student-result-detail-report-two',
                compact(
                    'result_list_array',
                    'report_tittle',
                    'report_tittle2',
                    'result_system_list',
                    'domain',
                    'resultSetting',
                    'site_info'
                )
            )
                ->setPaper('a4', 'landscape')->setWarnings(false);
        }
    } elseif ($resultSetting['sheet_no'] == 'three') {
        // if($request->page_orientaion=='portrate'){
        $pdf = PDF::loadView(
            'default.admin.site.result.result_report.site-base-multiple-student-result-detail-report-three',
            compact('result_list_array', 'report_tittle', 'report_tittle2', 'result_system_list', 'domain', 'resultSetting', 'site_info')
        )
            ->setWarnings(false);
        // }
        // else if($request->page_orientaion=='landscape'){
        //     $pdf = PDF::loadView('default.admin.site.result.result_report.site-base-landscape-multiple-student-result-detail-report-two',
        //         compact('result_list_array', 'report_tittle', 'report_tittle2', 'result_system_list', 'domain',
        //          'resultSetting','site_info'))
        //         ->setPaper('a4', 'landscape')->setWarnings(false);
        // }

    }elseif ($resultSetting['sheet_no'] == 'four'){
      
            $pdf = PDF::loadView(
                'default.admin.site.result.result_report.site-base-multiple-student-result-detail-report-four',
                compact('result_list_array', 'report_tittle', 'report_tittle2', 'result_system_list', 'domain', 'resultSetting', 'site_info')
            )
                ->setWarnings(false);
      
            // $pdf = PDF::loadView(
            //     'default.admin.site.result.result_report.site-base-landscape-multiple-student-result-detail-report',
            //     compact(
            //         'result_list_array',
            //         'report_tittle',
            //         'report_tittle2',
            //         'result_system_list',
            //         'domain',
            //         'resultSetting',
            //         'site_info'
            //     )
            // )
            //     ->setPaper('a4', 'landscape')->setWarnings(false);
       
    } else {

        if ($request->page_orientaion == 'portrate') {
            $pdf = PDF::loadView(
                'default.admin.site.result.result_report.site-base-multiple-student-result-detail-report',
                compact('result_list_array', 'report_tittle', 'report_tittle2', 'result_system_list', 'domain', 'resultSetting', 'site_info')
            )
                ->setWarnings(false);
        } else if ($request->page_orientaion == 'landscape') {
            $pdf = PDF::loadView(
                'default.admin.site.result.result_report.site-base-landscape-multiple-student-result-detail-report',
                compact(
                    'result_list_array',
                    'report_tittle',
                    'report_tittle2',
                    'result_system_list',
                    'domain',
                    'resultSetting',
                    'site_info'
                )
            )
                ->setPaper('a4', 'landscape')->setWarnings(false);
        }
    }
        
        
     
        $path = storage_path() . '/pdf';

     //   dd($path);
       // $time = \Auth::user()->id . '-' . Carbon::now()->unix();
        $random=rand(0,100000);
        $time = $random. '-' . Carbon::now()->unix();
        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        $name = $time . '.pdf';


        return Response::json(['link' => route('open-pdf-file-storage-for-public', [$name]),
            'message' => 'Successfully Created Card Report'], 200);
   }

   public function openReportForPublic($name)
   {
       try {
           if (!file_exists(storage_path('pdf/' . $name))) {
               return "The file existed only for 1 day and deleted today!";
           }
           return response()->file(storage_path('pdf/' . $name));

       } catch (Exception $exception) {
           return Response::json(['message' => $exception->getMessage()], 410);
       }
   }

}
